% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program PlotSDT.m

function [pHit, pFA] = plotSDT(dprime, c)

x = (-300:(300+dprime*100))/100;
N = normpdf(x, 0, 1);
SN = normpdf(x, dprime, 1);
xc = [c c];
yc = [0 0.5];
plot (x, N, 'k-', x, SN, 'k-', xc, yc, 'k-');

pHit = 1 - normcdf(c, dprime, 1);
pFA = 1 - normcdf(c, 0, 1);


